#include <ole2.h>
#include <Windows.h>
#include <objbase.h>
#include <stdio.h>
#include "abstools_sendmail.h"




// Generic function to check the success of an operation.  If the
// operation failed, this function prints the formatted error message
// and returns 0.  Otherwise, it returns 1.
//
int check_success(HRESULT hr) {

    // If we had success, simply return 1.
    //
    if (SUCCEEDED(hr)) {
        return 1;
    }

    char *szError; // Error message buffer.

    // Try to format the message and print it out.
    //
    if(FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|
                     FORMAT_MESSAGE_FROM_SYSTEM,
                     NULL,
                     hr,
                     MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
                     (LPSTR)&szError, 
                     0, 
                     NULL) != 0)
    {

        fprintf(stderr, "Error: %s\n", szError);
        LocalFree(szError);

    } else {

        // If, for some reason, we could not format the error,
        // let the user know.
        //
        fprintf(stderr, "Unknown error!\n");

    }

    return 0; // indicate failure

}









int main(int argc, char* argv[])
{

    // *************** Declare Some Variables ********************

    // Variables that will be used and re-used in our calls
    DISPPARAMS dpNoArgs = {NULL, NULL, 0, 0};
    OLECHAR FAR* szMethod;
    BSTR bstrTemp;
    VARIANT vArgsMethod[100];
    DISPPARAMS dpMethod;

    // DISPIDs
    DISPID dispid_Method;

    BSTR bstrEmptyString;
    bstrEmptyString = ::SysAllocString(OLESTR(""));

    VARIANT vFalse;
    vFalse.vt = VT_BOOL;
    vFalse.boolVal = FALSE;

    VARIANT vResultString;
    vResultString.vt = VT_BSTR;
    vResultString.bstrVal = ::SysAllocString(OLESTR(""));

    // ******************** Start Automation ***********************

    //Initialize the COM libraries
    ::CoInitialize(NULL);

    // Create an instance of the Word application and obtain the 
    // pointer to the application's IDispatch interface.
    CLSID clsid;
    CLSIDFromProgID(L"absTools-SendMail", &clsid);  

    IUnknown* pUnk;
    HRESULT hr = ::CoCreateInstance( clsid, NULL, CLSCTX_SERVER,
                                     IID_IUnknown, (void**) &pUnk);
    IDispatch* pDispApp;
    hr = pUnk->QueryInterface(IID_IDispatch, (void**)&pDispApp);


	printf("Return value: %d\n", check_success(hr));


	//Set up the DISPPARAMS for the Unlock method
    dpMethod.cArgs = 3;
    dpMethod.cNamedArgs = 0;
    dpMethod.rgvarg = vArgsMethod;

    bstrTemp = ::SysAllocString(OLESTR("John Doe"));
    vArgsMethod[2].vt = VT_BSTR;         
    vArgsMethod[2].bstrVal = bstrTemp;

    bstrTemp = ::SysAllocString(OLESTR("Doe Company"));
    vArgsMethod[1].vt = VT_BSTR;         
    vArgsMethod[1].bstrVal = bstrTemp;

    bstrTemp = ::SysAllocString(OLESTR("0000000000"));
    vArgsMethod[0].vt = VT_BSTR;         
    vArgsMethod[0].bstrVal = bstrTemp;

    szMethod = OLESTR("Unlock");
    hr = pDispApp->GetIDsOfNames(IID_NULL, &szMethod, 1, 
                                  LOCALE_USER_DEFAULT, 
                                  &dispid_Method);
    hr = pDispApp->Invoke(dispid_Method, IID_NULL, 
                                LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
                                &dpMethod, &vResultString, NULL, NULL);
	printf("Return value: %d\n", check_success(hr));
	printf("Control returned: %S\n", vResultString.bstrVal);

    ::SysFreeString(bstrEmptyString);







	//Set up the DISPPARAMS for the Init method
    dpMethod.cArgs = 1;
    dpMethod.cNamedArgs = 0;
    dpMethod.rgvarg = vArgsMethod;

    bstrTemp = ::SysAllocString(OLESTR("192.168.254.10"));
    vArgsMethod[0].vt = VT_BSTR;         
    vArgsMethod[0].bstrVal = bstrTemp;

    szMethod = OLESTR("Init");
    hr = pDispApp->GetIDsOfNames(IID_NULL, &szMethod, 1, 
                                  LOCALE_USER_DEFAULT, 
                                  &dispid_Method);
    hr = pDispApp->Invoke(dispid_Method, IID_NULL, 
                                LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
                                &dpMethod, NULL, NULL, NULL);
	printf("Return value: %d\n", check_success(hr));

    ::SysFreeString(bstrEmptyString);







	//Set up the DISPPARAMS for the SetSender method
    dpMethod.cArgs = 1;
    dpMethod.cNamedArgs = 0;
    dpMethod.rgvarg = vArgsMethod;

    bstrTemp = ::SysAllocString(OLESTR("support@abspdf.com"));
    vArgsMethod[0].vt = VT_BSTR;         
    vArgsMethod[0].bstrVal = bstrTemp;

    szMethod = OLESTR("SetSender");
    hr = pDispApp->GetIDsOfNames(IID_NULL, &szMethod, 1, 
                                  LOCALE_USER_DEFAULT, 
                                  &dispid_Method);
    hr = pDispApp->Invoke(dispid_Method, IID_NULL, 
                                LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
                                &dpMethod, NULL, NULL, NULL);
	printf("Return value: %d\n", check_success(hr));

    ::SysFreeString(bstrEmptyString);







	//Set up the DISPPARAMS for the AddRecipient method
    dpMethod.cArgs = 1;
    dpMethod.cNamedArgs = 0;
    dpMethod.rgvarg = vArgsMethod;

    bstrTemp = ::SysAllocString(OLESTR("info@abspdf.com"));
    vArgsMethod[0].vt = VT_BSTR;         
    vArgsMethod[0].bstrVal = bstrTemp;

    szMethod = OLESTR("AddRecipient");
    hr = pDispApp->GetIDsOfNames(IID_NULL, &szMethod, 1, 
                                  LOCALE_USER_DEFAULT, 
                                  &dispid_Method);
    hr = pDispApp->Invoke(dispid_Method, IID_NULL, 
                                LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
                                &dpMethod, NULL, NULL, NULL);
	printf("Return value: %d\n", check_success(hr));

    ::SysFreeString(bstrEmptyString);







	//Set up the DISPPARAMS for the SetMessage method
    dpMethod.cArgs = 3;
    dpMethod.cNamedArgs = 0;
    dpMethod.rgvarg = vArgsMethod;

    bstrTemp = ::SysAllocString(OLESTR("Message subject"));
    vArgsMethod[2].vt = VT_BSTR;         
    vArgsMethod[2].bstrVal = bstrTemp;
    bstrTemp = ::SysAllocString(OLESTR("Plain text message"));
    vArgsMethod[1].vt = VT_BSTR;         
    vArgsMethod[1].bstrVal = bstrTemp;
    bstrTemp = ::SysAllocString(OLESTR("<html>HTML <i>text</i></html>"));
    vArgsMethod[0].vt = VT_BSTR;         
    vArgsMethod[0].bstrVal = bstrTemp;

    szMethod = OLESTR("SetMessage");
    hr = pDispApp->GetIDsOfNames(IID_NULL, &szMethod, 1, 
                                  LOCALE_USER_DEFAULT, 
                                  &dispid_Method);
    hr = pDispApp->Invoke(dispid_Method, IID_NULL, 
                                LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
                                &dpMethod, NULL, NULL, NULL);
	printf("Return value: %d\n", check_success(hr));

    ::SysFreeString(bstrEmptyString);







	//Set up the DISPPARAMS for the SendMail method
    szMethod = OLESTR("SendMail");
    hr = pDispApp->GetIDsOfNames(IID_NULL, &szMethod, 1, 
                                  LOCALE_USER_DEFAULT, 
                                  &dispid_Method);
    hr = pDispApp->Invoke(dispid_Method, IID_NULL, 
                                LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
                                &dpNoArgs, NULL, NULL, NULL);
	printf("Return value: %d\n", check_success(hr));

    ::SysFreeString(bstrEmptyString);








	pDispApp->Release();
	pUnk->Release();


    

	
	
	
	
	::CoUninitialize();

    return 0;

}

